package ga.core.individual;

/**
 * Interface for getting an individuals cost.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface ICostInfo {
  /**
   * Get the costs as double.
   * 
   * @return Costs.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public double getCosts();

  /**
   * Get the textual representation of the costs.
   * 
   * @return Costs string.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public String getCostString();
}
